/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.mccs;

import com.quantumdata.mccs.Constants;
import com.quantumdata.mccs.MCCSGUIFrame;
import com.quantumdata.mccs.VCPCodes;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MySlider
implements ChangeListener,
MouseListener,
MouseMotionListener {
    private VCPCodes vcpCode;
    private JTextField jTextVal;
    private JSlider slider;
    private int sliderMaxVal = 255;

    public MySlider(String string, String string2, int n) {
        this.slider = Constants.createSlider(n, this, this, this);
        this.sliderMaxVal = n;
        this.init(string, string2);
    }

    public MySlider(String string, String string2) {
        this.slider = Constants.createSlider(this, this, this);
        this.init(string, string2);
    }

    private void init(String string, String string2) {
        this.slider.setEnabled(false);
        this.vcpCode = new VCPCodes(string, string2, "R/W", "C");
        this.jTextVal = Constants.createSliderText(String.valueOf(this.slider.getValue()));
    }

    private int getSliderValue(int n, double d) {
        int n2 = n <= 7 ? 0 : ((double)n >= d - 9.0 ? this.sliderMaxVal : (int)Math.round((double)((n - 7) * (this.sliderMaxVal + 1)) / (d - 7.0 - 9.0)));
        return n2;
    }

    public VCPCodes getVcpCode() {
        return this.vcpCode;
    }

    public void getSliderVal(boolean bl) {
        if (MCCSGUIFrame.readFromDisplay(this.vcpCode, bl) != 0) {
            if (MCCSGUIFrame.getReadRespSupportValue() != this.sliderMaxVal) {
                this.slider.setMaximum(MCCSGUIFrame.getReadRespSupportValue());
                this.sliderMaxVal = MCCSGUIFrame.getReadRespSupportValue();
            }
            this.slider.setValue(MCCSGUIFrame.getReadRespCurrentValue());
            this.jTextVal.setText(String.valueOf(MCCSGUIFrame.getReadRespCurrentValue()));
        }
    }

    public void sendSliderVal() {
        MCCSGUIFrame.writeToDisplay(this.vcpCode, this.slider.getValue());
    }

    public JTextField getNameField() {
        return this.vcpCode.getNameField();
    }

    public JTextField getSliderValField() {
        return this.jTextVal;
    }

    public JSlider getThisSlider() {
        return this.slider;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        JSlider jSlider = (JSlider)changeEvent.getSource();
        if (jSlider.getValueIsAdjusting()) {
            int n = jSlider.getValue();
            if (jSlider == this.slider && this.slider.isEnabled()) {
                this.jTextVal.setText(String.valueOf(n));
                this.slider.setValue(n);
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.sliderChanged(mouseEvent);
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        JSlider jSlider = (JSlider)mouseEvent.getSource();
        if (jSlider == this.slider && this.slider.isEnabled()) {
            int n = this.getSliderValue(mouseEvent.getX(), jSlider.getSize().getWidth());
            if (n > this.sliderMaxVal) {
                n = this.sliderMaxVal;
            }
            this.slider.setToolTipText(this.vcpCode.getNameWithCode() + ": " + String.valueOf(n));
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.sliderChanged(mouseEvent);
    }

    private void sliderChanged(MouseEvent mouseEvent) {
        JSlider jSlider = (JSlider)mouseEvent.getSource();
        if (jSlider == this.slider && this.slider.isEnabled()) {
            int n = this.getSliderValue(mouseEvent.getX(), jSlider.getSize().getWidth());
            if (n > this.sliderMaxVal) {
                n = this.sliderMaxVal;
            }
            this.jTextVal.setText(String.valueOf(n));
            this.slider.setValue(n);
            if (this.vcpCode.getVcpCode().equalsIgnoreCase("13")) {
                MCCSGUIFrame.setBacklightControl();
            } else {
                MCCSGUIFrame.writeToDisplay(this.vcpCode, this.slider.getValue());
            }
        }
    }
}

